/**
 * Copyright © 2024 Mimocodes. All rights reserved.
 */
/*browser:true*/
/*global define*/
define(
    [
        'uiComponent',
        'Magento_Checkout/js/model/payment/renderer-list'
    ],
    function (
        Component,
        rendererList
    ) {
        'use strict';

         var currency;

         currency = window.checkoutConfig.currency;

         if(currency == 'EGP'){
           rendererList.push(
             {
               type: 'aman_express',
               component: 'Aman_AmanAccept/js/view/payment/method-renderer/aman_express'
             },
             {
               type: 'aman_pos',
               component: 'Aman_AmanAccept/js/view/payment/method-renderer/aman_pos'
             },
             {
               type: 'aman_shahry',
               component: 'Aman_AmanAccept/js/view/payment/method-renderer/aman_shahry'
             },
             {
               type: 'aman_valu',
               component: 'Aman_AmanAccept/js/view/payment/method-renderer/aman_valu'
             },
             {
               type: 'aman_mobile_wallet',
               component: 'Aman_AmanAccept/js/view/payment/method-renderer/aman_mobile_wallet'
             },
             {
               type: 'aman_card_installment',
               component: 'Aman_AmanAccept/js/view/payment/method-renderer/aman_card_installment'
             },
             {
               type: 'aman_now',
               component: 'Aman_AmanAccept/js/view/payment/method-renderer/aman_now'
             },
           );
         }else{
           rendererList.push(
             {
               type: 'aman_pkr_express',
               component: 'Aman_AmanAccept/js/view/payment/method-renderer/aman_pkr_express'
             }
           );
         }

        /** Add view logic here if needed */
        return Component.extend({});
    }
);
