<?php

/**
 * Copyright © 2024 Mimocodes. All rights reserved.
 */

namespace Aman\AmanAccept\Model\Ui\AmanExpress;

use Aman\AmanAccept\Gateway\Config\AmanExpress\Config;
use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Framework\Session\SessionManagerInterface;

/**
 * Class ConfigProvider
 */
class ConfigProvider implements ConfigProviderInterface
{
    const Aman_Express_Code = 'aman_express';
    const Aman_POS_Code = 'aman_pos';
    const Aman_SHAHRY_Code = 'aman_shahry';
    const Aman_Pkr_Express_Code = 'aman_pkr_express';
    const Aman_Mobile_Wallet_Code = 'aman_mobile_wallet';
    const Aman_Valu_Code = 'aman_valu';
    const Aman_Card_Installment_Code = 'aman_card_installment';
    const Aman_Now_Code = 'aman_now';
    /**
     * @var Config
     */
    private $config;

    /**
     * @var SessionManagerInterface
     */
    private $session;

    protected $amanExpressConfig;


    /**
     * Constructor
     *
     * @param Config $config
     * @param SessionManagerInterface $session
     */
    public function __construct(
        Config $config,
        SessionManagerInterface $session,
        \Aman\AmanAccept\Gateway\Config\AmanExpress\Config $amanExpressConfig
    ) {
        $this->config = $config;
        $this->session = $session;
        $this->amanExpressConfig = $amanExpressConfig;
    }

    /**
     * Retrieve assoc array of checkout configuration
     *
     * @return array
     */
    public function getConfig()
    {
        $storeId = $this->session->getStoreId();
        $isActive = $this->config->isActive($storeId);
        $currency = $this->amanExpressConfig->getCurrency($storeId);
        return [
            'payment' => [
                self::Aman_Express_Code => [
                    'title' => $this->config->getTitle(),
                    'callback_url' => $this->config->getCallbackUrl(),
                ],
                self::Aman_POS_Code => [
                    'active' => $isActive,
                    'title' => "Pay Cash at Aman POS",
                ],
                self::Aman_SHAHRY_Code => [
                    'active' => $isActive,
                    'title' => "Pay using Shahry",
                ],
                self::Aman_Pkr_Express_Code => [
                    'title' => $this->config->getTitle(),
                    'active' => $isActive,
                    'callback_url' => $this->config->getCallbackUrl(),
                ],
                self::Aman_Valu_Code => [
                  'active' => $isActive,
                  'title' => 'Pay using ValU',
                ],
                self::Aman_Mobile_Wallet_Code => [
                  'active' => $isActive,
                  'title' => 'Pay using Mobile Wallet',
                ],
                self::Aman_Card_Installment_Code => [
                  'active' => $isActive,
                  'title' => 'Pay using Aman Card',
                ],
                self::Aman_Now_Code => [
                  'active' => $isActive,
                  'title' => 'Pay using AmanNOW',
                ]
            ],
            'currency' => $currency
        ];
    }
}
