<?php

/**
 * Copyright © 2021 Junnan Sun. All rights reserved.
 */

namespace Aman\AmanAccept\Model\Ui\AmanBankInstallment;

use Aman\AmanAccept\Gateway\Config\AmanExpress\Config;
use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Framework\Session\SessionManagerInterface;

/**
 * Class ConfigProvider
 */
class ConfigProvider implements ConfigProviderInterface
{
    const Aman_Card_Installmentode = 'aman_card_installment';


    /**
     * @var Config
     */
    private $config;

    /**
     * @var SessionManagerInterface
     */
    private $session;


    /**
     * Constructor
     *
     * @param Config $config
     * @param SessionManagerInterface $session
     */
    public function __construct(
        Config $config,
        SessionManagerInterface $session
    ) {
        $this->config = $config;
        $this->session = $session;

    }

    /**
     * Retrieve assoc array of checkout configuration
     *
     * @return array
     */
    public function getConfig()
    {
        $storeId = $this->session->getStoreId();
        return [
            'payment' => [
                self::Aman_Card_InstallmentCode => [
                    'isActive' => 1,
                    'title' => "Pay using Aman Card Installment",
                ]
            ]
        ];
    }
}
