<?php
namespace Aman\AmanAccept\Model\Api\Data;

use \Magento\Framework\Api\AttributeValueFactory;

/**
 * Payload data model
 *
 * @SuppressWarnings(PHPMD.ExcessivePublicCount)
 */
class Payload extends \Magento\Framework\Api\AbstractExtensibleObject implements
    \Aman\AmanAccept\Api\Data\PayloadInterface
{

    /**
     * Initialize dependencies.
     *
     * @param \Magento\Framework\Api\ExtensionAttributesFactory $extensionFactory
     * @param AttributeValueFactory $attributeValueFactory
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\Api\ExtensionAttributesFactory $extensionFactory,
        AttributeValueFactory $attributeValueFactory,
        $data = []
    ) {
        parent::__construct($extensionFactory, $attributeValueFactory, $data);
    }

    /**
     * Get payload transactionReference
     *
     * @return string|null
     */
    public function getTransactionReference()
    {
        return $this->_get(self::TRANSACTION_REFERENCE);
    }

    /**
     * Set payload country
     *
     * @param string $country
     * @return $this
     */
    public function setTransactionReference($transactionReference)
    {
        return $this->setData(self::getTransactionReference, $transactionReference);
    }

    /**
     * Get order reference
     *
     * @return string|null
     */
    public function getOrderReference()
    {
        return $this->_get(self::ORDER_REFERENCE);
    }

    /**
     * Set order reference
     *
     * @param string $orderReference
     * @return $this
     */
    public function setOrderReference($orderReference)
    {
        return $this->setData(self::ORDER_REFERENCE, $orderReference);
    }

    /**
     * Get merchant reference
     *
     * @return string|null
     */
    public function getMerchantReference()
    {
        return $this->_get(self::MERCHANT_REFERENCE);
    }

    /**
     * Set merchant reference
     *
     * @param string $merchantReference
     * @return $this
     */
    public function setMerchantReference($merchantReference)
    {
        return $this->setData(self::MERCHANT_REFERENCE, $merchantReference);
    }

    /**
     * Get payment method
     *
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->_get(self::PAYMENT_METHOD);
    }

    /**
     * Set merchant reference
     *
     * @param string $paymentMethod
     * @return $this
     */
    public function setPaymentMethod($paymentMethod)
    {
        return $this->setData(self::PAYMENT_METHOD, $paymentMethod);
    }

    /**
     * Get amount
     *
     * @return string
     */
    public function getAmount()
    {
        return $this->_get(self::AMOUNT);
    }

    /**
     * Set amount
     *
     * @param string $amount
     * @return $this
     */
    public function setAmount($amount)
    {
        return $this->setData(self::AMOUNT, $amount);
    }

    /**
     * Get currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->_get(self::CURRENCY);
    }

    /**
     * Set currency
     *
     * @param string $currency
     * @return $this
     */
    public function setCurrency($currency)
    {
        return $this->setData(self::CURRENCY, $currency);
    }

    /**
     * Get status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->_get(self::STATUS);
    }

    /**
     * Set status
     *
     * @param string $status
     * @return $this
     */
    public function setStatus($status)
    {
        return $this->setData(self::STATUS, $status);
    }

    /**
     * Get created at time
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->_get(self::CREATED_AT);
    }

    /**
     * Set created at time
     *
     * @param string $createdAt
     * @return $this
     */
    public function setCreatedAt($updatedAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

    /**
     * Get updated at time
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->_get(self::UPDATED_AT);
    }

    /**
     * Set updated at time
     *
     * @param string $updatedAt
     * @return $this
     */
    public function setUpdatedAt($updatedAt)
    {
        return $this->setData(self::UPDATED_AT, $updatedAt);
    }

    /**
     * Get transaction Type
     *
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->_get(self::TRANSACTION_TYPE);
    }

    /**
     * Set transaction Type
     *
     * @param string $transactionType
     * @return $this
     */
    public function setTransactionType($transactionType)
    {
        return $this->setData(self::TRANSACTION_TYPE, $transactionType);
    }

    /**
     * Get transaction Fees
     *
     * @return string|null
     */
    public function getTransactionFees()
    {
        return $this->_get(self::TRANSACTION_FEES);
    }

    /**
     * Set transaction Fees
     *
     * @param string $transactionFees
     * @return $this
     */
    public function setTransactionFees($transactionFees)
    {
        return $this->setData(self::TRANSACTION_FEES, $transactionFees);
    }

    /**
     * Get Customer Name
     *
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->_get(self::CUSTOMER_NAME);
    }

    /**
     * Set Customer Name
     *
     * @param string $customerName
     * @return $this
     */
    public function setCustomerName($customerName)
    {
        return $this->setData(self::CUSTOMER_NAME, $customerName);
    }

    /**
     * Get Customer Phone Number
     *
     * @return string|null
     */
    public function getCustomerPhoneNumber()
    {
        return $this->_get(self::CUSTOMER_PHONE_NUMBER);
    }

    /**
     * Set Customer Phone Number
     *
     * @param string $customerPhoneNumber
     * @return $this
     */
    public function setCustomerPhoneNumber($customerPhoneNumber)
    {
        return $this->setData(self::CUSTOMER_PHONE_NUMBER, $customerPhoneNumber);
    }

    /**
     * Get Customer Email
     *
     * @return string|null
     */
    public function getCustomerEmail()
    {
        return $this->_get(self::CUSTOMER_EMAIL);
    }

    /**
     * Set Customer Email
     *
     * @param string $customerEmail
     * @return $this
     */
    public function setCustomerEmail($customerEmail)
    {
        return $this->setData(self::CUSTOMER_EMAIL, $customerEmail);
    }

    /**
     * Get Customer Address
     *
     * @return string|null
     */
    public function getCustomerAddress()
    {
        return $this->_get(self::CUSTOMER_ADDRESS);
    }

    /**
     * Set Customer Address
     *
     * @param string $customerAddress
     * @return $this
     */
    public function setCustomerAddress($customerAddress)
    {
        return $this->setData(self::CUSTOMER_ADDRESS, $customerAddress);
    }

    /**
     * Get hmac
     *
     * @return string|null
     */
    public function getHmac()
    {
        return $this->_get(self::HMAC);
    }

    /**
     * Set hmac
     *
     * @param string $hmac
     * @return $this
     */
    public function setHmac($hmac)
    {
        return $this->setData(self::HMAC, $hmac);
    }
}
