<?php


/**
 * Copyright © 2024 Mimocodes. All rights reserved.
 */

namespace Aman\AmanAccept\Model\Adapter\Lib;

class Api
{
	public function get($url,$data,$options= array())
	{
		$httpClient = new \GuzzleHttp\Client();
		$query_encoded = http_build_query($data , null, '&', 2);
		$query = urldecode($query_encoded);
		$query = str_replace('%20' , ' ' , $query);
		try
		{
			$response = $httpClient->request('GET' ,$url. '?' . $query);
			$response = json_decode($response->getBody()->getContents(), true);
		}
		catch (GuzzleHttp\Exception\ClientException $e)
		{
			$response = $e->getResponse();
			$response = (string) $response->getBody();
			// $response['status'] = 500;
			// $response['error'] = "Internal Server Error";
		}
		return $response;
	}

	public function post($url,$merchantID,$publicKey,$body,$options= array())
	{


		$httpClient = new \GuzzleHttp\Client();

		$headers = [
            'Content-Type' => 'application/json',
            'Accept'       => 'application/json',
            'Authorization' => 'Bearer '. $publicKey,
            'merchantReference' => $merchantID,
            'ClientSource'=>'MAGENTO'
        ];

		//return json_encode($headers). "," . json_encode( $body , true);

		try {
			$response = $httpClient->request('POST', $url, [
				'headers' => $headers,
				'body' => json_encode( $body , true)
			]);

			$response = json_decode($response->getBody()->getContents(), true);
		} catch (\GuzzleHttp\Exception\RequestException $e) {
			$response = $e->getResponse();
			return $response->getBody()->getContents();
		}

		return $response;
	}
}
