<?php

/**
 * Copyright © 2024 Mimocodes. All rights reserved.
 */

namespace Aman\AmanAccept\Model\Adapter\Lib;


/**
 * Aman Accept api lib
 * used to manage Aman Accept API calls
 *
 */


use Aman\AmanAccept\Model\Adapter\Lib\api as Api;
use Aman\AmanAccept\Model\Adapter\Lib\ValidationException as ValidationException;
use Aman\AmanAccept\Model\Adminhtml\Source\Environment;
use \Exception as Exception;

Class AmanApi
{

	private $api_endpoint_acceptCreatePaymentUrl;
	private $api_endpoint_acceptPaymentStatusUrl;

	private $environment;
	private $secretKey;
	private $publicKey;


	private $merchantID;
	private $acceptCreatePaymentUrlTest;
	private $acceptCreatePaymentUrlProduction;
	private $acceptPaymentStatusUrlTest;
	private $acceptPaymentStatusUrlProduction;

	 function __construct($secretKey,$publicKey,$environment,$merchantID,
	 $acceptCreatePaymentUrlTest, $acceptCreatePaymentUrlProduction,
	 $acceptPaymentStatusUrlTest, $acceptPaymentStatusUrlProduction)
	{
		$this->Api = new Api();

		$this->secretKey 		= $secretKey;
		$this->publicKey	= $publicKey;
		$this->environment 		= $environment;

		$this->merchantID 		= $merchantID;
		$this->acceptCreatePaymentUrlTest = $acceptCreatePaymentUrlTest;
		$this->acceptCreatePaymentUrlProduction = $acceptCreatePaymentUrlProduction;
		$this->acceptPaymentStatusUrlTest = $acceptPaymentStatusUrlTest;
		$this->acceptPaymentStatusUrlProduction = $acceptPaymentStatusUrlProduction;


        if ($environment === Environment::ENVIRONMENT_PRODUCTION) {
			$this->api_endpoint_acceptCreatePaymentUrl  = $this->acceptCreatePaymentUrlProduction;
            $this->api_endpoint_acceptPaymentStatusUrl  = $this->acceptPaymentStatusUrlProduction;
        } else {
			$this->api_endpoint_acceptCreatePaymentUrl  = $this->acceptCreatePaymentUrlTest;
			$this->api_endpoint_acceptPaymentStatusUrl  = $this->acceptPaymentStatusUrlTest;
		}
	}


	public function environment($value=null)
    {
        if (empty($value)) {
            return $this->environment;
		}

        if ($environment === Environment::ENVIRONMENT_PRODUCTION) {
			$this->api_endpoint_acceptCreatePaymentUrl  = $this->acceptCreatePaymentUrlProduction;
            $this->api_endpoint_acceptPaymentStatusUrl  = $this->acceptPaymentStatusUrlProduction;
        } else {
			$this->api_endpoint_acceptCreatePaymentUrl  = $this->acceptCreatePaymentUrlTest;
			$this->api_endpoint_acceptPaymentStatusUrl  = $this->acceptPaymentStatusUrlTest;
		}

		$this->environment = $value;
	}

	public function secretKey($value=null)
    {
        if (empty($value)) {
            return $this->secretKey;
        }
        $this->secretKey = $value;
	}

	public function publicKey($value=null)
    {
        if (empty($value)) {
            return $this->publicKey;
        }
        $this->publicKey = $value;
	}

	public function getPaymentStatus($data) {

		//generate the hash first
		ksort($data);
		$sha512 = hash_hmac('sha512', json_encode($data), $this->secretKey);
		// return $sha512 . "---" . json_encode($data);
		// $sha512 = "bea01a420657276aa117e39e5c91863320ce3ee58db189b8686705986c2b8b98a96a792a755cdcc034496cc02889a36d066a00f9ad5da6d4a43b7acbb7670e60";

		$response = $this->Api->post($this->api_endpoint_acceptPaymentStatusUrl,$this->merchantID,$sha512,$data);

		return $response;
	}

	public function postAmanCreatePayment($body) {
		$response = $this->Api->post($this->api_endpoint_acceptCreatePaymentUrl,$this->merchantID,$this->publicKey,$body);
		return $response;
	}

}
