<?php

/**
 * Copyright © 2024 Mimocodes. All rights reserved.
 */

namespace Aman\AmanAccept\Model\Adapter;

use Aman\AmanAccept\Gateway\Config\AmanExpress\Config;
use Magento\Framework\ObjectManagerInterface;

class AmanAdapterFactory
{
    /**
     * @var ObjectManagerInterface
     */
    private $objectManager;

    /**
     * @var Config
     */
    private $config;

    /**
     * @param ObjectManagerInterface $objectManager
     * @param Config $config
     */
    public function __construct(ObjectManagerInterface $objectManager, Config $config)
    {
        $this->config = $config;
        $this->objectManager = $objectManager;
    }

    /**
     * Creates instance of Aman Accept Adapter.
     *
     * @param int|null $storeId
     * @return AmanAdapter
     */
    public function create($storeId = null)
    {
        return $this->objectManager->create(
            AmanAdapter::class,
            [
                'secretKey' => $this->config->getSecretKey($storeId),
                'publicKey' => $this->config->getPublicKey($storeId),
                'environment' => $this->config->getEnvironment($storeId),
                'merchantID' => $this->config->getMerchantID($storeId),
                'acceptCreatePaymentUrlTest' => $this->config->getAmanAcceptCreatePaymentUrlTest($storeId),
                'acceptCreatePaymentUrlProduction' => $this->config->getAmanAcceptCreatePaymentUrlProduction($storeId),
                'acceptPaymentStatusUrlTest' => $this->config->getAmanAcceptPaymentStatusUrlTest($storeId),
                'acceptPaymentStatusUrlProduction' => $this->config->getAmanAcceptPaymentStatusUrlProduction($storeId),
            ]
        );
    }
}
