<?php

/**
 * Copyright © 2024 Mimocodes. All rights reserved.
 */

namespace Aman\AmanAccept\Model\Adapter;

use Aman\AmanAccept\Model\Adapter\Lib\AmanDataFormatter;
use Aman\AmanAccept\Model\Adapter\Lib\AmanApi;

use Aman\AmanAccept\Model\Adminhtml\Source\Environment;

class AmanAdapter
{
    /**
     * @var AmanApi
     */
    private $api;

    public function __construct($secretKey, $publicKey, $environment, $merchantID,
                                $acceptCreatePaymentUrlTest, $acceptCreatePaymentUrlProduction,
                                $acceptPaymentStatusUrlTest, $acceptPaymentStatusUrlProduction)
    {

        $this->api = new AmanApi($secretKey,$publicKey,$environment,$merchantID,
        $acceptCreatePaymentUrlTest, $acceptCreatePaymentUrlProduction,
        $acceptPaymentStatusUrlTest, $acceptPaymentStatusUrlProduction);


    }


    /**
     * @param string|null $value
     * @return mixed
     */
    public function environment($value = null)
    {
        return $this->api->environment($value);
    }

    /**
     * @param string|null $value
     * @return mixed
     */
    public function secretKey($value = null)
    {
        return $this->api->secretKey($value);
    }

    /**
     * @param string|null $value
     * @return mixed
     */
    public function publicKey($value = null)
    {
        return $this->api->publicKey($value);
    }

    public function amanCreatePayment($chargeRequest)
    {
        return $this->api->postAmanCreatePayment($chargeRequest);
    }

    public function getPaymentStatus($data) {
        return $this->api->getPaymentStatus($data);
    }
}
