<?php

/**
 * Copyright © 2024 Mimocodes. All rights reserved.
 */

namespace Aman\AmanAccept\Gateway\Config\AmanExpress;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Aman\AmanAccept\Model\Ui\AmanExpress\ConfigProvider;
use Aman\AmanAccept\Model\Adminhtml\Source\Environment;

/**
 * Class Config
 */
class Config extends \Magento\Payment\Gateway\Config\Config
{
    const KEY_ACTIVE = 'active';
    const KEY_TITLE = 'title';

    const KEY_ENVIRONMENT = 'environment';

    const KEY_SECRET_KEY_TEST = 'aman_secret_key_test';
    const KEY_PUBLIC_KEY_TEST = 'public_key_test';
    const KEY_CASHIER_CREATE_PAYMENT_TEST = 'acceptcreatepaymenttest';
    const KEY_CASHIER_PAYMENT_STATUS_TEST = 'acceptpaymentstatustest';
//    const KEY_AES_KEY_TEST = 'aes_key_test';


    const KEY_SECRET_KEY = 'aman_secret_key';
    const KEY_PUBLIC_KEY = 'public_key';
    const KEY_CASHIER_CREATE_PAYMENT_PRODUCTION = 'acceptcreatepaymentproduction';
    const KEY_CASHIER_PAYMENT_STATUS_PRODUCTION = 'acceptpaymentstatusproduction';
//    const KEY_AES_KEY = 'aes_key';



    const KEY_AMAN_MERCHANT_ID = 'aman_merchant_id';
    const KEY_CALLBACK_URL = 'callback_url';

    const KEY_CURRENCY = 'currency';


    /**
     * Initialize dependencies.
     *
     * @param ScopeConfigInterface $scopeConfig
     * @param null $methodCode
     * @param string $pathPattern
     */
    public function __construct(
        ScopeConfigInterface $scopeConfig,
        $methodCode = ConfigProvider::Aman_Express_Code,
        $pathPattern = self::DEFAULT_PATH_PATTERN
    ) {
        parent::__construct($scopeConfig, $methodCode, $pathPattern);
    }

    /**
     * Get Payment configuration status
     *
     * @return bool
     */
    public function isActive()
    {
        return (bool) $this->getValue(self::KEY_ACTIVE);
    }

    /**
     * Get title of payment
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->getValue(self::KEY_TITLE);
    }

    public function getAmanAcceptCreatePaymentUrlTest()
    {
        return $this->getValue(self::KEY_CASHIER_CREATE_PAYMENT_TEST);
    }
    public function getAmanAcceptCreatePaymentUrlProduction()
    {
        return $this->getValue(self::KEY_CASHIER_CREATE_PAYMENT_PRODUCTION);
    }


    public function getAmanAcceptPaymentStatusUrlTest()
    {
        return $this->getValue(self::KEY_CASHIER_PAYMENT_STATUS_TEST);
    }
    public function getAmanAcceptPaymentStatusUrlProduction()
    {
        return $this->getValue(self::KEY_CASHIER_PAYMENT_STATUS_PRODUCTION);
    }


//    public function getAESKeyTest()
//    {
//        return $this->getValue(self::KEY_AES_KEY_TEST);
//    }
//    public function getAESKeyProduction()
//    {
//        return $this->getValue(self::KEY_AES_KEY);
//    }


    /**
     * Gets value of configured environment.
     *
     * Possible values: production or sandbox.
     *
     * @param int|null $storeId
     * @return string
     */
    public function getEnvironment($storeId = null)
    {
        return $this->getValue(Config::KEY_ENVIRONMENT, $storeId);
    }

    /**
     * Gets Secret Key for production
     *
     * @param int|null $storeId
     * @return string
     */
    public function getSecretKey($storeId = null)
    {
        if($this->getEnvironment() == Environment::ENVIRONMENT_PRODUCTION)
        {
            return $this->getValue(Config::KEY_SECRET_KEY, $storeId);
        }
        else
        {
            return $this->getValue(Config::KEY_SECRET_KEY_TEST, $storeId);
        }
    }


    /**
     * Gets Merchant ID
     *
     * @param int|null $storeId
     * @return string
     */
    public function getMerchantID($storeId = null)
    {
        return $this->getValue(Config::KEY_AMAN_MERCHANT_ID, $storeId);
    }



    /**
     * Gets Merchant public_key for production
     *
     * @param int|null $storeId
     * @return string
     */
    public function getPublicKey($storeId = null)
    {
        if($this->getEnvironment() == Environment::ENVIRONMENT_PRODUCTION)
        {
            return $this->getValue(self::KEY_PUBLIC_KEY, $storeId);
        }
        else
        {
            return $this->getValue(self::KEY_PUBLIC_KEY_TEST, $storeId);
        }
    }

    public function getCallbackUrl($storeId = null)
    {
        return $this->getValue(self::KEY_CALLBACK_URL, $storeId);
    }

    public function getCurrency($storeId = null)
    {
      return $this->getValue(Config::KEY_CURRENCY, $storeId);
    }

}
