<?php

/**
 * Copyright © 2024 Mimocodes. All rights reserved.
 */

namespace Aman\AmanAccept\Controller\Response;

use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\App\Action\Context;
use Magento\Checkout\Model\Session;
use Magento\Sales\Model\Order;
use Magento\Sales\Model\OrderFactory;
use Aman\AmanAccept\Logger\Logger;
use Aman\AmanAccept\Gateway\Config\AmanExpress\Config;
use Magento\Framework\App\Response\Http;
use Magento\Sales\Model\Order\Payment\Transaction\Builder as TransactionBuilder;
use Magento\Sales\Model\Order\Payment\Transaction;

use Magento\Sales\Api\OrderRepositoryInterface;



class Index extends  \Magento\Framework\App\Action\Action
{
	protected $_objectmanager;
	protected $_checkoutSession;
	protected $_orderFactory;
	protected $urlBuilder;
	private $logger;
	protected $response;
	protected $config;
	protected $messageManager;
	protected $transactionRepository;
	protected $cart;
	protected $inbox;

    protected $adapterFactory;

	public function __construct( Context $context,
			Session $checkoutSession,
			OrderFactory $orderFactory,
			Logger $logger,
			Config $config,
			Http $response,
			TransactionBuilder $tb,
			 \Magento\Checkout\Model\Cart $cart,
			 \Magento\AdminNotification\Model\Inbox $inbox,
			 \Magento\Sales\Api\TransactionRepositoryInterface $transactionRepository,
			 OrderRepositoryInterface $orderRepository,
			 \Magento\Framework\Api\SearchCriteriaBuilderFactory $searchCriteriaBuilderFactory,
			 \Aman\AmanAccept\Model\Adapter\AmanAdapterFactory $adapterFactory
		) {


        $this->checkoutSession = $checkoutSession;
        $this->orderFactory = $orderFactory;
        $this->response = $response;
        $this->config = $config;
        $this->transactionBuilder = $tb;
		$this->logger = $logger;
        $this->cart = $cart;
        $this->inbox = $inbox;
        $this->transactionRepository = $transactionRepository;
		$this->urlBuilder = \Magento\Framework\App\ObjectManager::getInstance()
							->get('Magento\Framework\UrlInterface');

		$this->orderRepository = $orderRepository;
		$this->searchCriteriaBuilder = $searchCriteriaBuilderFactory->create();

		$this->adapterFactory = $adapterFactory;

		parent::__construct($context);
    }

	//localhost/amanpayment/response/?order_no=111
	public function execute()
	{
		$this->logger->info("Receiving response payload ". json_encode($this->getRequest()->getParams()));
		try{
			$orderNo = $this->getRequest()->getParam("orderNo");
			$type = $this->getRequest()->getParam("type");
			$this->checkoutSession->setTestData($type);
			$this->checkoutSession->setLastQuoteId($orderNo)->setLastSuccessQuoteId($orderNo);
			$this->checkoutSession->setLastOrderId($orderNo);
			$this->logger->info("Redirecting now to checkout/onepage/success/");
			$this->_redirect($this->urlBuilder->getUrl('checkout/onepage/success/',  ['_secure' => true]));

		}catch(Exception $e){
			$this->logger->info($e->getMessage());
			$this->_redirect($this->urlBuilder->getBaseUrl());
		}
	}
}
