<?php

namespace Aman\AmanAccept\Api\Data;

interface PayloadInterface
{
    /**#@+
     * Constants defined for keys of the data array. Identical to the name of the getter in snake case
     */
    const TRANSACTION_REFERENCE = 'transactionReference';
    const ORDER_REFERENCE = 'orderReference';
    const MERCHANT_REFERENCE = 'merchantReference';
    const PAYMENT_METHOD = 'paymentMethod';
    const AMOUNT = 'amount';
    const CURRENCY = 'currency';
    const STATUS = 'status';
    const CREATED_AT = 'createdAT';
    const UPDATED_AT = 'updatedAT';
    const TRANSACTION_TYPE = 'transactionType';
    const TRANSACTION_FEES = 'transactionFees';
    const CUSTOMER_NAME = 'customerName';
    const CUSTOMER_PHONE_NUMBER = 'customerPhoneNumber';
    const CUSTOMER_EMAIL = 'customerEmail';
    const CUSTOMER_ADDRESS = 'customerAddress';
    const HMAC = 'hmac';
    // const POS_ID = 'posId';

    /**
     * Get transaction reference
     *
     * @return string|null
     */
    public function getTransactionReference();

    /**
     * Set transaction reference
     *
     * @param string $reference
     * @return $this
     */
    public function setTransactionReference($transactionReference);

    /**
     * Get payload order reference
     *
     * @return string|null
     */
    public function getOrderReference();

    /**
     * Set payload order reference
     *
     * @param string $orderReference
     * @return $this
     */
    public function setOrderReference($orderReference);

    /**
     * Get payload merchant reference
     *
     * @return string|null
     */
    public function getMerchantReference();

    /**
     * Set payload merchant reference
     *
     * @param string $merchantReference
     * @return $this
     */
    public function setMerchantReference($merchantReference);

    /**
     * Get payload payment method
     *
     * @return string|null
     */
    public function getPaymentMethod();

    /**
     * Set payload payment method
     *
     * @param string $paymentMethod
     * @return $this
     */
    public function setPaymentMethod($paymentMethod);

    /**
     * Get amount
     *
     * @return string
     */
    public function getAmount();

    /**
     * Set amount
     *
     * @param string $amount
     * @return $this
     */
    public function setAmount($amount);
    /**
   * Get Currency
   *
   * @return string|null
   */
  public function getCurrency();

  /**
   * Set Currency
   *
   * @return string|null
   */
  public function setCurrency($currency);

    /**
     * Get status
     *
     * @return string|null
     */
    public function getStatus();

    /**
     * Set status
     *
     * @param string $status
     * @return $this
     */
    public function setStatus($status);

    /**
     * Get created at time
     *
     * @return string|null
     */
    public function getCreatedAt();

    /**
     * Set created at time
     *
     * @param string $createdAt
     * @return $this
     */
    public function setCreatedAt($createdAt);

    /**
     * Get updated at time
     *
     * @return string|null
     */
    public function getUpdatedAt();

    /**
     * Set updated at time
     *
     * @param string $updatedAt
     * @return $this
     */
    public function setUpdatedAt($updatedAt);

    /**
     * Get transactionFees
     *
     * @return string|null
     */
    public function getTransactionFees();

    /**
     * Set transactionFees
     *
     * @param string $transactionFees
     * @return $this
     */
    public function setTransactionFees($transactionFees);

    /**
     * Get transactionType
     *
     * @return string|null
     */
    public function getTransactionType();

    /**
     * Set transactionType
     *
     * @param string $transactionType
     * @return $this
     */
    public function setTransactionType($transactionType);


    /**
     * Get customerName
     *
     * @return string|null
     */
    public function getCustomerName();

    /**
     * Set customerName
     *
     * @param string $customerName
     * @return $this
     */
    public function setCustomerName($customerName);

    /**
     * Get customerPhoneNumber
     *
     * @return string|null
     */
    public function getCustomerPhoneNumber();

    /**
     * Set customerPhoneNumber
     *
     * @param string $customerPhoneNumber
     * @return $this
     */
    public function setCustomerPhoneNumber($customerPhoneNumber);

    /**
     * Get customerEmail
     *
     * @return string|null
     */
    public function getCustomerEmail();

    /**
     * Set customerEmail
     *
     * @param string $customerEmail
     * @return $this
     */
    public function setCustomerEmail($customerEmail);

    /**
     * Get customerAddress
     *
     * @return string|null
     */
    public function getCustomerAddress();

    /**
     * Set customerAddress
     *
     * @param string $customerAddress
     * @return $this
     */
    public function setCustomerAddress($customerAddress);


    /**
     * Get hmac
     *
     * @return string|null
     */
    public function getHmac();

    /**
     * Set hmac
     *
     * @param string $hmac
     * @return $this
     */
    public function setHmac($hmac);

    
    // /**
    //  * Get POS Id
    //  *
    //  * @return string|null
    //  */
    // public function getPosId();

    // /**
    //  * Set POS ID
    //  *
    //  * @param string $podId
    //  * @return $this
    //  */
    // public function setPosId($podId); 

}
